# -*- coding: utf-8 -*-
"""r09.ipynb

Automatically generated by Colaboratory.

Original file is located at
    https://colab.research.google.com/drive/1KsKtGhFGovdq8_oHkQdUD9iQ1QvgnFVe
"""

import numpy as np
import matplotlib.pyplot as plt
import matplotlib.gridspec as gridspec


# UWAGA: poniżej zdefiniowano globalne ustawienia związane z wyglądem rysunków,
# które wykorzystano do wygenerowania rysunków pokazanych w książce

from IPython import display
display.set_matplotlib_formats('svg') # Rysunki w formacie wektorowym
plt.rcParams.update({'font.size':14}) # Rozmiar czcionki



"""# Macierze ortogonalne"""

Q1 = np.array([ [1,-1],[1,1] ]) / np.sqrt(2)
Q2 = np.array([ [1,2,2],[2,1,-2],[-2,2,-1] ]) / 3

print( np.round(Q1.T @ Q1,8) ), print(' ')

print( np.round(Q2.T @ Q2,8) )



"""# Rozkład QR"""

A = np.random.randn(6,6)

Q,R = np.linalg.qr(A)



fig = plt.figure(figsize=(10,6))
axs = [0]*5
c = 1.5

gs1 = gridspec.GridSpec(2,6)
axs[0] = plt.subplot(gs1[0,:2])
axs[0].imshow(A,vmin=-c,vmax=c,cmap='gray')
axs[0].set_title('A',fontweight='bold')

axs[1] = plt.subplot(gs1[0,2:4])
axs[1].imshow(Q,vmin=-c,vmax=c,cmap='gray')
axs[1].set_title('Q',fontweight='bold')

axs[2] = plt.subplot(gs1[0,4:6])
axs[2].imshow(R,vmin=-c,vmax=c,cmap='gray')
axs[2].set_title('R',fontweight='bold')

axs[3] = plt.subplot(gs1[1,1:3])
axs[3].imshow(A - Q@R,vmin=-c,vmax=c,cmap='gray')
axs[3].set_title('A - QR',fontweight='bold')

axs[4] = plt.subplot(gs1[1,3:5])
axs[4].imshow(Q.T@Q,cmap='gray')
axs[4].set_title(r'Q$^T$Q',fontweight='bold')

for a in axs:
  a.set_xticks([])
  a.set_yticks([])

plt.tight_layout()
plt.savefig('rys9.1.png',dpi=300)
plt.show()



M = 4
N = 14

A = np.random.randn(M,N)
Q,R = np.linalg.qr(A)

print(f'Size of A (M,N): {A.shape}')
print(f'Size of Q (M,N): {Q.shape}')
print(f'Size of R (M,N): {R.shape}')

A = np.array([ [1,-1] ]).T

Q,R = np.linalg.qr(A,'complete')
Q*np.sqrt(2) # przeskalowuję przez sqrt(2), aby otrzymać liczby całkowite





"""# Ćwiczenie 1."""

# obliczam macierze
Q  = np.linalg.qr( np.random.randn(5,5) )[0]
Qt = Q.T
Qi = np.linalg.inv( Q )

# QtQ
print(np.round( Qt@Q,8 )), print(' ')

# QQt
print(np.round( Q@Qt,8 )), print(' ')

# Q^-1 Q
print(np.round( Qi@Q,8 )), print(' ')

# QQ^-1
print(np.round( Q@Qi,8 ))



"""# Ćwiczenie 2."""

# tworzę macierz
m = 4
n = 4
A = np.random.randn(m,n)

# inicjalizacja
Q = np.zeros((m,n))


# ortogonalizacja Grama-Schmidta
for i in range(n):

    # inicjalizacja
    Q[:,i] = A[:,i]

    # ortogonalizacja
    a = A[:,i]
    for j in range(i): # pętla jedynie po wcześniejszych kolumnach
        q = Q[:,j]
        Q[:,i]=Q[:,i]-np.dot(a,q)/np.dot(q,q)*q

    # normalizacja
    Q[:,i] = Q[:,i] / np.linalg.norm(Q[:,i])


# "prawdziwy" rozkład QR dla porównania
Q2,R = np.linalg.qr(A)


# uwaga na możliwe różnice w znakach
# po wykonaniu dodawania wszystkie niezerowe kolumny z pierwszej macierzy powinny zawierać zera w drugiej
print( np.round( Q-Q2 ,10) ), print(' ')
print( np.round( Q+Q2 ,10) )



"""# Ćwiczenie 3."""

# tworzę ortogonalną macierz i przypisuję ją do zmiennej U (aby uniknąć pomylenia z Q)
U = np.linalg.qr( np.random.randn(6,6) )[0]


# część 2.: zmiana norm
for i in range(U.shape[0]):
  U[:,i] = U[:,i]*(10+i)


# część 3.: zmiana wartości jednego elementu
U[0,3] = 0 # to element q_{1,4}


# rozkład QR
q,r = np.linalg.qr(U)

print( np.round(r,3) ), print(' ')
# print( np.round(Q.T@Q,4))



"""# Ćwiczenie 4."""

# funkcja obliczająca odwrotność
def oldSchoolInv(A):

  # rozmiar macierzy
  m = A.shape[0]


  # przerywam obliczenia, jeżeli macierz nie jest kwadratowa
  if not np.diff(A.shape)[0]==0:
    raise Exception('Macierz musi być kwadratowa.')

  # przerywam obliczenia, jeżeli macierz jest osobliwa
  if np.linalg.matrix_rank(A)<m:
    raise Exception('Macierz musi mieć pełen rząd.')


  # inicjalizacja
  M = np.zeros((m,m)) # macierz minorów
  G = np.zeros((m,m)) # siatka

  # obliczam macierz minorów
  for i in range(m):
    for j in range(m):

      # wybieram wiersze i kolumny
      rows = [True]*m
      rows[i] = False

      cols = [True]*m
      cols[j] = False

      # obliczam minory
      M[i,j]=np.linalg.det(A[rows,:][:,cols])

      # tworzę siatkę
      G[i,j] = (-1)**(i+j)


  # obliczam macierz dopełnień algebraicznych
  C = M * G

  # obliczam odwrotność
  return C.T / np.linalg.det(A)

# tworzę macierz
n = 5
A = np.random.randn(n,n)

# odwrotność z metody oldSchoolInv
Ainv_old = oldSchoolInv(A)
AAi_old  = Ainv_old@A

# odwrotność z rozkładu QR
Q,R = np.linalg.qr(A)
Ainv_qr = oldSchoolInv(R)@Q.T
AAi_qr  = Ainv_qr@A



# różnica
trueI = np.eye(n)
sse = [0,0] # sse = suma kwadratów błędów
sse[0] = np.sqrt(np.sum((AAi_old-trueI)**2))
sse[1] = np.sqrt(np.sum((AAi_qr-trueI )**2))


# tworzę wykres
plt.figure(figsize=(6,6))

plt.bar(range(2),sse,color=[.7,.7,.7])
plt.xticks(range(2),labels=['Staromodna metoda','Rozkład QR'])
plt.ylim([0,np.max(sse)*1.1])
plt.ylabel('Odl. euklidesowa do macierzy jednostkowej')
plt.title(f'Błąd w obliczeniach odwrotności\n(macierz o wymiarach {n}x{n})\n',ha='center')
plt.savefig('rys9.3.png',dpi=300, bbox_inches="tight")
plt.show()



"""# Ćwiczenie 5."""

# przeprowadzam eksperyment

# rozmiar macierzy
n = 5

numExprs = 100

sse = np.zeros((numExprs,2))

for expi in range(numExprs):

  # tworzę macierz
  A = np.random.randn(n,n)

  # odwrotność z metody oldSchoolInv
  Ainv_old = oldSchoolInv(A)
  AAi_old  = Ainv_old@A

  # odwrotność z rozkładu QR
  Q,R = np.linalg.qr(A)
  Ainv_qr = oldSchoolInv(R)@Q.T
  # Ainv_qr = np.linalg.inv(R)@Q.T
  AAi_qr  = Ainv_qr@A

  # różnice
  trueI = np.eye(n)
  sse[expi,0] = np.sqrt(np.sum((AAi_old-trueI)**2))
  sse[expi,1] = np.sqrt(np.sum((AAi_qr-trueI )**2))


# wykres
plt.figure(figsize=(6,6))

plt.plot(np.zeros(numExprs),sse[:,0],'ko')
plt.plot(np.ones(numExprs),sse[:,1],'ko')
plt.bar(range(2),np.mean(sse,axis=0),color=[.7,.7,.7])

plt.xticks(range(2),labels=['Staromodna metoda','Rozkład QR'])
plt.ylim([0,np.max(sse)*1.1])
plt.ylabel('Odl. euklidesowa do macierzy jednostkowej')
plt.title(f'Błąd w obliczeniach odwrotności\n(macierz o wymiarach {n}x{n})\n',ha='center')
plt.savefig('rys9.4a.png',dpi=300, bbox_inches="tight")
plt.show()

# ciąg dalszy, część b

# rozmiar macierzy
n = 30

numExprs = 100

sse = np.zeros((numExprs,2))

for expi in range(numExprs):

  # tworzę macierz
  A = np.random.randn(n,n)

  # odwrotność z metody oldSchoolInv
  Ainv_old = oldSchoolInv(A)
  AAi_old  = Ainv_old@A

  # odwrotność z rozkładu QR
  Q,R = np.linalg.qr(A)
  Ainv_qr = oldSchoolInv(R)@Q.T
  # Ainv_qr = np.linalg.inv(R)@Q.T
  AAi_qr  = Ainv_qr@A

  # różnice
  trueI = np.eye(n)
  sse[expi,0] = np.sqrt(np.sum((AAi_old-trueI)**2))
  sse[expi,1] = np.sqrt(np.sum((AAi_qr-trueI )**2))


plt.figure(figsize=(6,6))

plt.plot(np.zeros(numExprs),sse[:,0],'ko')
plt.plot(np.ones(numExprs),sse[:,1],'ko')
plt.bar(range(2),np.mean(sse,axis=0),color=[.7,.7,.7])

plt.xticks(range(2),labels=['Staromodna metoda','Rozkład QR'])
plt.ylim([0,np.max(sse)*1.1])
plt.ylabel('Odl. euklidesowa do macierzy jednostkowej')
plt.title(f'Błąd w obliczeniach odwrotności\n(macierz o wymiarach {n}x{n})\n',ha='center')
plt.savefig('rys9.4b.png',dpi=300, bbox_inches="tight")
plt.show()



"""# Ćwiczenie 6."""

# tworzę losową macierz ortogonalną
n = 13
Q,R = np.linalg.qr(np.random.randn(n,n))

# wyświetlam normy
print( np.linalg.norm(Q,2),               # norma 2.
       np.sqrt( np.sum(Q**2) )/np.sqrt(n) # ręcznie obliczona norma Frobeniusa
)

# wpływ mnożenia macierzy na normę wektora
# wektor wartości losowych
v = np.random.randn(n,1)

# normy
norm_v  = np.linalg.norm(v)
norm_Qv = np.linalg.norm(Q@v)

print(norm_v)
print(norm_Qv)



"""# Ćwiczenie 7."""

# macierz
A = np.random.randn(10,4)

# R
_,R = np.linalg.qr(A,'complete')

# sprawdzenie R
np.round(R,3)

# odwracalna podmacierz
Rsub = R[:4,:]

# odwrotności
Rsub_inv = np.linalg.inv(Rsub)
Rleftinv = np.linalg.pinv(R)

print('Pełna odwrotność podmacierzy R :')
print(np.round(Rsub_inv,3)), print(f'\n\n')

print('Lewostronna odwrotność R:')
print(np.round(Rleftinv,3))

